<?php
// ++=========================================================================++
// || vBadvanced Gallery v1.0 RC2
// ||              
// ||             .
// ||       (  )
// || tranlated by: arabsdesign.com
// || www.arabsdesign.com
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE);
define('NO_REGISTER_GLOBALS', 1);

$globaltemplates = array(
	'ADV_GALLERY_UPLOAD',
	'adv_gallery_upload_custombits'
);

$actiontemplates = array(
	'doupload' => array(
		'ADV_GALLERY_UPLOAD',
		'ADV_GALLERY_UPLOAD_APPROVE',
		'adv_gallery_upload_approvebits',
		'adv_gallery_nodisplay'
	)
);

$phrasegroups = array(
	'adv_gallery_upload'
);

$specialtemplates = array();

define('GET_IMGTYPE_ARRAY', true);

require_once('./gallery_global.php');

if (empty($_REQUEST['do']))
{
	$_REQUEST['do'] = 'upload';
}

// ############################## Start Uploading #############################
if ($_REQUEST['do'] == 'doupload')
{
	globalize($_REQUEST, array('userfile', 'imageinfo', 'imageoptions', 'server', 'images', 'processfiles', 'doprocess', 'processedcatids', 'page' => INT, 'catid' => INT));

	$massimageinfo['title'] = htmlspecialchars($imageinfo['title']);
	$massimageinfo['catid'] = intval($imageinfo['catid']);
	$massimageinfo['description'] = htmlspecialchars($imageinfo['description']);
	$massimageinfo['keywords'] = htmlspecialchars($imageinfo['keywords']);
	$massimageinfo['asuser'] = htmlspecialchars($imageinfo['asuser']);

	if (!$massimageinfo['catid'])
	{
		eval(print_standard_error('adv_gallery_must_choose_category'));
	}

	if (strlen($massimageinfo['description']) > $vba_options['gallery_desclimit'])
	{
		$desclength = number_format(strlen($massimageinfo['description']));
		eval(print_standard_error('adv_gallery_description_toolong'));
	}

	if ($imageinfo['asuser'] AND $imageinfo['asuser'] != $bbuserinfo['username'] AND ($permissions['gallerypermissions'] & CANUPLOADASUSER))
	{
		$user = $DB_site->query_first("SELECT userid, username FROM " . TABLE_PREFIX . "user WHERE username = '" . addslashes($imageinfo['asuser']) . "'");
		if (!$user['userid'])
		{
			eval(print_standard_error('adv_gallery_upload_invaliduser'));
		}
		$userid = $user['userid'];
		$username = $user['username'];
	}
	else
	{
		$userid = $bbuserinfo['userid'];
		$username = $bbuserinfo['username'];
	}

	$folders = preg_split('//', $userid, -1, PREG_SPLIT_NO_EMPTY);

	foreach ($folders AS $uid)
	{
		$folderstring .= '/' . $uid;
		if (!is_dir($vba_options['gallery_filedirectory'] . $folderstring))
		{
			@mkdir($vba_options['gallery_filedirectory'] . $folderstring, 0777);
			@chmod($vba_options['gallery_filedirectory'] . $folderstring, 0777);

			if ($fp = @fopen($vba_options['gallery_filedirectory'] . $folderstring . '/index.html', "w"))
			{
				@fputs ($fp, '');
				@fclose($fp);
			}
			else
			{
				eval(print_standard_error('adv_gallery_problem_creating_folder'));
			}
		}
	}

	require_once('./includes/functions_gallery_imageedit.php');

	$categoryperms = fetch_category_perms();

	$userinfo = $DB_site->query_first("SELECT SUM(filesize) AS normal, SUM(originalfilesize) AS original FROM " . TABLE_PREFIX . "adv_gallery_images WHERE userid = '$userid'");

	$userinfo['usedspace'] = $userinfo['normal'] + $userinfo['original'];

	$imageoptions['subscribe'] = intval($imageoptions['subscribe']);
	$imageoptions['favorite'] = intval($imageoptions['favorite']);

	if ($imageoptions['subscribe'])
	{
		$checked['subscribe'] = 'checked="checked"';
	}

	if ($imageoptions['favorite'])
	{
		$checked['favorite'] = 'checked="checked"';
	}

	$catemail = array();
	$catemails = $DB_site->query("SELECT catid, title, newimageemail FROM " . TABLE_PREFIX . "adv_gallery_categories WHERE newimageemail != ''");
	while ($categoryemails = $DB_site->fetch_array($catemails))
	{
		$catemail["$categoryemails[catid]"] = $categoryemails;
	}

	if (empty($processedcatids))
	{
		$processedcatids = array();
	}

	$filetypes = fetch_cat_ext_info();

	$nextpage = $page + 1;

	// ################# Mass uploading from server #################
	if (!$page)
	{
		if ($server['upload'])
		{
			$processfiles = array();
			$errors = array();

			if (!($permissions['gallerypermissions'] & CANUPLOADFROMSERVER))
			{
				print_adv_no_permission();
			}

			$dir = $vba_options['gallery_userfolder'] . '/' . $bbuserinfo['userid'];

			if ($dh = @opendir($dir))
			{
				while (($file = readdir($dh)) !== false)
				{
					if ($file != '.' AND $file != '..')
					{
						$imagecount++;
						$imageinfo = fetch_image_info($dir . '/' . $file, $file);
						$imageinfo['catid'] = $massimageinfo['catid'];
						$errors["$imageinfo[saveas]"] = check_upload_errors();
						@chmod($dir . '/' . $file, 0777);
						if (empty($errors["$imageinfo[saveas]"]))
						{
							$processfiles[] = $imageinfo['truename'];
						}
					}
				}
				closedir($dh);
			}
		}
		else
		{
			// ###################### Uploading Single File(s) ######################
			$server['process_number'] = $vba_options['gallery_uploadinputs'];
			foreach ($_FILES AS $file)
			{
				if ($file['tmp_name'])
				{
					$gotfiles = true;
					$imageinfo = fetch_image_info($file['tmp_name'], $file['name'], 0);
					$imageinfo['catid'] = $massimageinfo['catid'];

					$errors["$imageinfo[saveas]"] = check_upload_errors();

					if (!empty($errors["$imageinfo[saveas]"]))
					{
						$show['errors'] = true;
					}
					else
					{
						$imagecount++;
						@move_uploaded_file($file['tmp_name'], $imageinfo['saveto'] . '/' . $imageinfo['saveas']);
						$processfiles[] = $imageinfo['saveas'];
					}
				}
			}

			if (!$gotfiles)
			{
				eval('$errors[\'\'][\'\'] = "' . fetch_phrase('attachnofile', PHRASETYPEID_ERROR) . '";');
			}
		}
	}

	// Print out any initial errors
	if (!empty($errors))
	{
		foreach ($errors AS $filename => $error)
		{
			if (!empty($error))
			{
				$show['errors'] = true;
				$uploaderrors .= '<tr><td class="thead">' . $filename . '</td></tr>';
				foreach ($error AS $varname => $text)
				{
					$uploaderrors .= '<tr><td class="alt1">' . $text . '</td></tr>';
				}
			}
		}
	}

	// Grab custom fields to display
	$custominfo = array();
	$customfields = $DB_site->query("SELECT * FROM " . TABLE_PREFIX . "adv_gallery_customfields ORDER BY displayorder");
	while ($field = $DB_site->fetch_array($customfields))
	{
		$custominfo[] = $field;
	}
	$DB_site->free_result($customfields);
	unset($field);

	// Only got 1 file?
	if (!$page AND sizeof($processfiles) == 1 AND !$show['errors'])
	{
		$singlefile = true;
		$fname = implode('', $processfiles);
		$images["$fname"] = &$imageinfo;
		$doprocess = &$processfiles;

		$imageinfo = fetch_image_info(iif($server['upload'], $vba_options['gallery_userfolder'] . '/' . $bbuserinfo['userid'], $vba_options['gallery_filedirectory'] . $folderstring) . '/' . $filename, $filename);
		resize_image($vba_options['gallery_thumbsize'], $vba_options['gallery_thumbsize']);

		$customfields = array();
		foreach ($custominfo AS $customfield)
		{
			$fieldvalue = $_POST["field$customfield[fieldid]"];
			unset ($_POST["field$customfield[fieldid]"]);
			$_POST["field$customfield[fieldid]"]["$fname"] = $fieldvalue;
		}

		unset($processfiles);
	}

	// Process current approved images
	if (!empty($images))
	{
		if (!is_array($doprocess))
		{
			$doprocess = array();
		}
		foreach ($images AS $filename => $imageinfo)
		{
			$filename = stripslashes($filename);
			$imageinfo = fetch_image_info(iif($server['upload'], $vba_options['gallery_userfolder'] . '/' . $bbuserinfo['userid'], $vba_options['gallery_filedirectory'] . $folderstring) . '/' . $filename, $filename);

			$imageinfo['asuser'] = $massimageinfo['asuser'];
			if (in_array($filename, $doprocess))
			{
				$customfields = array();

				foreach ($custominfo AS $customfield)
				{
					$customfields["field$customfield[fieldid]"] = $_POST["field$customfield[fieldid]"]["$filename"];
				}

				$errors["$imageinfo[saveas]"] = check_upload_errors();

				if (!empty($errors["$imageinfo[saveas]"]))
				{
					@unlink($imageinfo['location']);
					@unlink($vba_options['gallery_filedirectory'] . $folderstring . '/' . $imageinfo['shortname'] . '_thumb.' . $imageinfo['extension']);
				}
				else
				{
					if ($server['upload'])
					{
						@copy($imageinfo['location'], $imageinfo['saveto'] . '/' . $imageinfo['saveas']);
						@unlink($imageinfo['location']);
						$imageinfo['location'] = $imageinfo['saveto'] . '/' . $imageinfo['saveas'];
					}

					$newimageid = process_upload(true);
					$imagecount++;

					if (!in_array($imageinfo['catid'], $processedcatids))
					{
						if ($categoryperms["$imageinfo[catid]"]['moderateimages'] OR $vba_options['gallery_newimageemail_all'])
						{
							$sednmailto = array();
							$optmailer = array();

							if (!empty($catemail["$catinfo[catid]"]))
							{
								$sendmailto = explode(' ', $catemail['newimageemail']);
							}

							if ($vba_options['gallery_newimageemail'])
							{
								$optmailer = explode(' ', $vba_options['gallery_newimageemail']);
							}

							$sendmailto = array_merge($optmailer, $sendmailto);

							if (!empty($sendmailto))
							{
								$cattitle = stripslashes($categorycache["$imageinfo[catid]"]['title']);
								foreach ($sendmailto AS $email)
								{
									eval(fetch_email_phrases('adv_gallery_newupload', 0));
									vbmail(trim($email), $subject, $message);
								}
							}
						}
						$processedcatids[] = $imageinfo['catid'];
					}
				}
			}
			else
			{
				@unlink($imageinfo['location']);
				@unlink($vba_options['gallery_filedirectory'] . $folderstring . '/' . $imageinfo['shortname'] . '_thumb.' . $imageinfo['extension']);
			}
		}
		unset($images, $imageinfo);
	}

	// Process new files
	if (!empty($processfiles))
	{
		$processcount = 0;
		$categoryselect = print_cat_select($massimageinfo['catid'], 'upload');
		$show['tablerows'] = true;

		if (!empty($custominfo))
		{
			foreach ($custominfo AS $customfield)
			{
				$hiddencustomvalues .= '<input type="hidden" name="defaultfields[field' . $customfield['fieldid'] . ']" value="' . addslashes(htmlspecialchars(iif(!$page, $_POST["field$customfield[fieldid]"], $_POST['defaultfields']["field$customfield[fieldid]"]))) . '" />';

			}
			unset($customfield);
		}

		foreach ($processfiles AS $file)
		{
			if ($processcount < $server['process_number'])
			{
				$processcount++;

				$imageinfo['catid'] = $massimageinfo['catid'];

				$imageinfo = fetch_image_info(iif($server['upload'], $vba_options['gallery_userfolder'] . '/' . $bbuserinfo['userid'], $vba_options['gallery_filedirectory'] . $folderstring) . '/' . $file, $file);

				// Do another error check if we have a page specified just to be safe
				if ($page)
				{
					$errors["$imageinfo[saveas]"] = check_upload_errors();

					if (!empty($errors["$imageinfo[saveas]"]) AND !in_array(fetch_phrase('adv_gallery_duplicate', PHRASETYPEID_ERROR), $errors["$imageinfo[saveas]"]))
					{
						@unlink($imageinfo['location']);
						@unlink($vba_options['gallery_filedirectory'] . $folderstring . '/' . $imageinfo['shortname'] . '_thumb.' . $imageinfo['extension']);
					}
				}

				if (!$massimageinfo['title'])
				{
					$massimageinfo['title'] = htmlspecialchars($imageinfo['shortname']);
					$unsettitle = true;
				}

				$_POST['defaultfields']['imageid'] = $file;
				$_POST['imageid'] = $file;
				$custombits = construct_custom_fieldbits(iif($page, $_POST['defaultfields'], $_POST), $custominfo, false, false, true);

				$imageinfo['userid'] = $userid;

				$imageinfo = resize_image($vba_options['gallery_thumbsize'], $vba_options['gallery_thumbsize']);

				$image['imageurl'] = construct_image_url($imageinfo, 'thumbname');
				eval('$imagebits .= "' . fetch_template('adv_gallery_upload_approvebits') . '";');
				unset($imageinfo);
				if ($unsettitle)
				{
					$massimageinfo['title'] = '';
				}
			}
			else
			{
				$hiddenbits .= '<input type="hidden" name="processfiles[]" value="' . htmlspecialchars($file) . '" />';
			}
		}
	}
	else
	{
		$colspan = 3;
		eval('$imagebits = "' . fetch_template('adv_gallery_nodisplay') . '";');
	}

	if (!$server['upload'] AND empty($processfiles) AND !$show['errors'])
	{
		if ($categoryperms["$massimageinfo[catid]"]['moderateimages'])
		{
			eval(print_standard_error('adv_gallery_imageupload_approve'));
		}
		else
		{
			if ($singlefile)
			{
				$url = 'showimage.php?' . $session['sessionurl'] . 'i=' . $newimageid;
			}
			else
			{
				$url = 'browseimages.php?' . $session['sessionurl'] . 'c=' . $massimageinfo['catid'];
			}
			eval(print_standard_redirect('gallery_imageuploaded_noapprove'));
		}
	}
	else
	{
		if ($singlefile)
		{
			$url = 'showimage.php?' . $session['sessionurl'] . 'i=' . $newimageid;
			eval(print_standard_redirect('gallery_imageuploaded_noapprove'));
		}
		else
		{
			$navbits[''] = $vbphrase['upload_image'];
			$navbar = construct_adv_navbar($navbits);

			if (!empty($processedcatids))
			{
				foreach ($processedcatids AS $pcatid)
				{
					$hiddenbits .= '<input type="hidden" name="processedcatids[]" value="' . intval($pcatid) . '" />';
				}
			}

			eval('print_output("' . fetch_template('ADV_GALLERY_UPLOAD_APPROVE') . '");');
		}
	}
}

// ############################## Main Upload Page ############################
if ($_REQUEST['do'] == 'upload')
{
	globalize($_POST, array('imageinfo'));

	$catoptions = print_cat_select($catid, 'upload');

	if (!$catoptions)
	{
		print_adv_no_permission();
	}

	$usedspace = $DB_site->query_first("SELECT SUM(filesize) AS normal, SUM(originalfilesize) AS original FROM " . TABLE_PREFIX ."adv_gallery_images WHERE userid = '$bbuserinfo[userid]'");

	$usedspace['total'] = $usedspace['normal'] + $usedspace['original'];

	if ($permissions['gallery_maxdiskspace'] == 0)
	{
		$spacelimit = $vbphrase['unlimited'];
		$spaceremaining = $vbphrase['unlimited'];
		$bar['spaceremaining'] = 100;
		$bar['spaceused'] = 1;
	}
	else
	{
		$spacelimit = make_good_size($permissions['gallery_maxdiskspace']);
		$spaceremaining = make_good_size($permissions['gallery_maxdiskspace'] - $usedspace['total']);

		$bar['spaceused'] = round(($usedspace['total'] / $permissions['gallery_maxdiskspace']) * 100);
		$bar['spaceremaining'] = 100 - $bar['spaceused'];

	}

	if ($bar['spaceused'] >= 75)
	{
		$bar['color'] = 'red';
	}
	else if ($bar['spaceused'] >= 50)
	{
		$bar['color'] = 'yellow';
	}
	else
	{
		$bar['color'] = 'green';
	}

	$spaceused = make_good_size($usedspace['total']);

	if (($permissions['gallerypermissions'] & CANUPLOADASUSER))
	{
		$show['userupload'] = true;
	}

	if (($permissions['gallerypermissions'] & CANUPLOADFROMSERVER))
	{
		$userdirectory = $vba_options['gallery_userfolder'] . '/' . $bbuserinfo['userid'];
		$show['serverupload'] = true;
	}

	$customfieldbits = construct_custom_fieldbits($_POST);

	for ($i = 0; $i < $vba_options['gallery_uploadinputs']; $i++)
	{
		$uploadbits .= '<div><input class="button" type="file" name="userfile' . $i . '" /></div>';
	}

	$navbits[''] = $vbphrase['upload_image'];
	$navbar = construct_adv_navbar($navbits);

	eval('print_output("' . fetch_template('ADV_GALLERY_UPLOAD') . '");');
}

?>